--> Pralable :
/*
USE master;
GO

CREATE DATABASE DB_CINEMA;
GO

USE DB_CINEMA;
GO
*/

CREATE TABLE T_FILM_FLM
(FLM_ID             INT IDENTITY NOT NULL PRIMARY KEY,
 FLM_TITRE          VARCHAR(250) NOT NULL,
 FLM_DUREE_MINUTE   FLOAT);

CREATE TABLE T_SALLE_SAL
(SAL_ID             INT IDENTITY NOT NULL PRIMARY KEY,
 SAL_NUMERO         SMALLINT NOT NULL);

CREATE TABLE T_HORAIRE_HOR
(HOR_DATE           DATE NOT NULL,
 HOR_HEURE          TIME NOT NULL,
 CONSTRAINT PK_HOR PRIMARY KEY (HOR_DATE, HOR_HEURE));

CREATE TABLE T_PROJECTION_PRJ
(PRJ_ID             INT IDENTITY NOT NULL PRIMARY KEY,
 HOR_DATE           DATE NOT NULL,
 HOR_HEURE          TIME NOT NULL,
 FLM_ID             INT NOT NULL,
 SAL_ID             INT NOT NULL,
 CONSTRAINT UK_PRJ_HDH_FML_SAL
            UNIQUE (HOR_DATE, HOR_HEURE, FLM_ID, SAL_ID),
 CONSTRAINT FK_PRJ_HOR FOREIGN KEY (HOR_DATE, HOR_HEURE)
            REFERENCES T_HORAIRE_HOR (HOR_DATE, HOR_HEURE),
 CONSTRAINT FK_PRJ_FLM FOREIGN KEY (FLM_ID)
            REFERENCES T_FILM_FLM (FLM_ID),
 CONSTRAINT FK_PRJ_SAL FOREIGN KEY (SAL_ID)
            REFERENCES T_SALLE_SAL (SAL_ID));